/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/

/**
 * \file    DM814x_psc.h
 *
 * \brief   Defines the module register defines for PSC
 *
 * This header file contains the Macros definitions and the
 * register overlay structure for DM814x Power & Sleep controller.
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _DM814x_psc_H_
#define _DM814x_psc_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_SoC.h"

/**
@addtogroup DM814x PSC
@{
*/

/*
 *====================
 * Enumerations
 *====================
 */
/**
 * \brief States of the Modules controlled by PSC for Various modules
 *
 *  This enumeration defines the various power states of modules controllable
 *  by the PSC module of DM814x.
 */
typedef enum eDm814x_Psc_State
	{
	PSC_SWRSTDISABLE = 0,	/**< Soft-Reset Disabled  		*/
	PSC_SYNCRESET	 = 1,	/**< Sync Reset  				*/
	PSC_DISABLE		 = 2,	/**< Disabled  					*/
	PSC_ENABLE		 = 3	/**< Enaled  					*/
	} eDm814x_Psc_State;

/*
 *====================
 * Defines
 *====================
 */
#define LPSC_C64X_CPU           1
#define LPSC_HD_VICP0           2
#define LPSC_HD_VICP1           3
#define LPSC_EDMA_CC            4
#define LPSC_EDMA_TC0           5
#define LPSC_EDMA_TC1           6
#define LPSC_EDMA_TC2           7
#define LPSC_EDMA_TC3           8
#define LPSC_USB                9
#define LPSC_ATA                10
#define LPSC_VLYNQ              11
#define LPSC_HPI                12
#define LPSC_PCI                13
#define LPSC_EMAC               14
#define LPSC_GRAPHICSENGINE     15
#define LPSC_VIDEO_PORT_0       16
#define LPSC_VIDEO_PORT_1       17
#define LPSC_STREAM_IO_0        18
#define LPSC_STREAM_IO_1        19
#define LPSC_DDR2_EMIF          20
#define LPSC_EMIFA              21
#define LPSC_MCASP0             22
#define LPSC_MCASP1             23
#define LPSC_CRGEN0             24
#define LPSC_CRGEN1             25
#define LPSC_UART0              26
#define LPSC_UART1              27
#define LPSC_UART2              28
#define LPSC_PWM0               29
#define LPSC_PWM1               30
#define LPSC_I2C                31
#define LPSC_SPI                32
#define LPSC_GPIO               33
#define LPSC_TIMER0             34
#define LPSC_TIMER1             35
#define LPSC_ARM_INTC           45

/* ------------------------------------------------------------------------ *
 *  Power and Sleep Controller ( PSC )                                      *
 * ------------------------------------------------------------------------ */
#define PSC_BASE                0x01c41000
#define PSC_PID                 *( volatile Uint32* )( PSC_BASE + 0x0 )
#define PSC_INTEVAL             *( volatile Uint32* )( PSC_BASE + 0x18 )
#define PSC_PTCMD               *( volatile Uint32* )( PSC_BASE + 0x120 )
#define PSC_PTSTAT              *( volatile Uint32* )( PSC_BASE + 0x128 )
#define PSC_PDSTAT0             *( volatile Uint32* )( PSC_BASE + 0x200 )
#define PSC_PDCTL0              *( volatile Uint32* )( PSC_BASE + 0x300 )
#define PSC_MDSTAT_BASE         ( PSC_BASE + 0x800 )
#define PSC_MDCTL_BASE          ( PSC_BASE + 0xa00 )


/* @} */   /* End of PSC */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM814x_psc_H_ */
